#pragma once

#include <string>
#include <map>
#include <vector>
#include <deque>
using namespace std;

struct Point {
    Point(double x = 0, double y = 0);

    double m_x, m_y;
};

struct Line {
    Line(double x0 = 0, double y0 = 0, double x1 = 0, double y1 = 0);
    Line(const Point &p0, const Point &r);


    // lot von punkt auf diese gerade
    void lot(const Point &p2, Point &lotP);

    // schnittpunkt mit gegebener gerade
    bool intersection(const Line &l2, Point &interP);

    // determines factor that has to be multiplied to m_r to get the point
    // if point not on line returns -9999
    double Factor(const Point &p);

    // punkt auf der gerade
    Point m_p0;
    // richtungsvektor
    Point m_r;
    // normalenvektor
    Point m_n;
    // konstante
    double m_c;
};


double CalcAngle(const Point &p);
double AngleDiff(double a1, double a2);


class MicroSecs {
public:
    // aktuelle Millisekunden setzen / lesen
    static double Now();

    static double GetMicroSecs() {
        return m_microSecs;
    }
    static unsigned long GetMilliSecs() {
        return (unsigned long)(m_microSecs / 1000.0);
    }

private:
    static double m_microSecs;
    static double sm_usProFineTick;
    static void InitTimer();
};


class MyCriticalSection {
public:
    MyCriticalSection();
    MyCriticalSection(const MyCriticalSection &src);
    ~MyCriticalSection(); 

    static MyCriticalSection* CreateInstance(const string &name);

    void Acquire(); 
    void Release(); 

protected:
    mutable CRITICAL_SECTION m_cs;		

    LPCRITICAL_SECTION GetCsPtr() { 
        return &m_cs; 
    }
};

class MyAutoLockCS
{
public:
    MyAutoLockCS( MyCriticalSection &cs)
        : m_Lock(cs)
    { 
        m_Lock.Acquire();
    }

    ~MyAutoLockCS() { 
        m_Lock.Release(); 
    }

protected:
    MyCriticalSection &m_Lock;		
};


// Type of flying objects
enum ObjectType { 
	NONE = 0, 
	ASTERIOD_SMALL = 1, ASTERIOD_MEDIUM = 2, ASTERIOD_BIG = 4,
	ASTERIOD_ANY = 7,
	UFO = 8,
	SHOT = 16,
	FF = 32,
	SHOT_ANY = 48,
};


class Statistics {
    static Statistics *sm_Instance;
    static MyCriticalSection sm_Lock;
    Statistics();

public:
    static Statistics* GetStatistics();

    void Reset();

    void SaveStatistics();

    MyCriticalSection m_DataLock;

    // current shot speed
    double m_SHOT_SPEED;

    // history of winkelbyte (CommL: write, PredictionL: read)
    deque<long> m_ViewIndexHisto; // 0: aktuell, 1: lter, 2: noch lter

    // history of last targets (CommL: write, PredictionL: read)
    deque< pair<unsigned int, double> > m_LastTargets; // 0: aktuell, 1: lter, 2: noch lter

    // LUT for angle -> WinkelByte
    map<double, BYTE> m_WinkelTab;

    // LUT for index / ViewAngle -> shot angle
    vector< pair<long, double> > m_AngleLUT;

    struct MoveHisto {
        MoveHisto(long fn = 0, long m = 0, long keyPing = 0, long framePing = 0)
            : m_FrameNo(fn), m_Move(m), m_KeyPing(keyPing), m_FramePing(framePing)
        {
        }

        long m_FrameNo;
        long m_Move;
        long m_KeyPing;
        long m_FramePing;
    };

    // key id - move
    deque<MoveHisto> m_LastMoves;
    // the latest received frame used this move
    // if > 0: some commands are still on their way; 
    //         have to apply missing ones to shot correctly!
    long m_MissingFrames;
    long m_MissingMoves;

    // last real view angles
    deque<long> m_LastViewAngles;

    long m_CurrentLevel; // current level

    // statistical values per level
    struct LevelData {
        LevelData() {
            m_Check_NumFFSuccess = m_Check_NumFFCount = 0;
            m_Frames = m_Points = m_NumUFO = m_NumAstros[ASTERIOD_SMALL] = m_NumAstros[ASTERIOD_MEDIUM] = m_NumAstros[ASTERIOD_BIG] = 0;
        }
        long m_NumAstros[8]; // overall number of astros: small / medium / big
        long m_NumUFO; // how often was the ufo on display
        long m_Check_NumFFCount; // how often where 4 friendy shots underway?
        long m_Check_NumFFSuccess; // how often could I fire earlier, if I wanted?
        long m_Points; // point made in this frame
        long m_Frames; // frames from first astro to last (including ufo)
    };
    vector<LevelData> m_Levels;
    long m_Score;
    long m_100K;
    bool m_GameRunning;
};


inline double NormalizeX(double x) {
	while (x < -512.0) x += 1024.0; // dx normalisieren auf -512 ... 511
	while (x > 511.0) x -= 1024.0;
    return x;
}

inline double NormalizeY(double y) {
	while (y < -384.0) y += 768.0; // dx normalisieren auf -512 ... 511
	while (y > 383.0) y -= 768.0;
    return y;
}

inline int NormalizeX(int x) {
	while (x < -512) x += 1024; // dx normalisieren auf -512 ... 511
	while (x > 511) x -= 1024;
    return x;
}

inline int NormalizeY(int y) {
	while (y < -384) y += 768; // dx normalisieren auf -512 ... 511
	while (y > 383) y -= 768;
    return y;
}
